<?php
define('UPLOAD_DIR', __DIR__ . '/../images/logos/');

function send_json_response($statusCode, $data) {
    header('Content-Type: application/json');
    http_response_code($statusCode);
    echo json_encode($data);
    exit();
}

if ($_SERVER['REQUEST_METHOD'] !== 'DELETE' && $_SERVER['REQUEST_METHOD'] !== 'GET') {
    send_json_response(405, ['success' => false, 'message' => 'Método no permitido.']);
}

if (!isset($_GET['filename']) || empty(trim($_GET['filename']))) {
    send_json_response(400, ['success' => false, 'message' => 'El nombre del archivo es requerido.']);
}

try {
    $filename = basename($_GET['filename']);
    $file_path = UPLOAD_DIR . $filename;

    $real_upload_dir = realpath(UPLOAD_DIR);
    $real_file_path = realpath($file_path);

    if ($real_file_path === false || strpos($real_file_path, $real_upload_dir) !== 0) {
        throw new Exception('Acceso denegado. Intento de acceder a una ruta no permitida.', 403);
    }

    if (is_file($real_file_path)) {
        if (unlink($real_file_path)) {
            send_json_response(200, ['success' => true, 'message' => 'Archivo eliminado exitosamente.']);
        } else {
            throw new Exception('No se pudo eliminar el archivo. Verifique los permisos.', 500);
        }
    } else {
        send_json_response(200, ['success' => true, 'message' => 'El archivo no existía, no se realizó ninguna acción.']);
    }

} catch (Exception $e) {
    $statusCode = $e->getCode() ?: 400; 
    send_json_response($statusCode, ['success' => false, 'message' => $e->getMessage()]);
}

?>