<?php
	$settings = \App\Models\Setting::first();
	if(!$settings){
		$settings = [];
	}
?>
<?php if($route == 'movements' && Auth::user()->role == 'reseller'): ?>
	<?php if($settings->allow_reseller_ae_movements == 1): ?>
		<a href="<?php echo e(route($route.'.create')); ?>" class="btn btn-success"><i class="fas fa-plus"></i> Nuevo</a>
	<?php endif; ?>
<?php else: ?>
	<a href="<?php echo e(route($route.'.create')); ?>" class="btn btn-success"><i class="fas fa-plus"></i> Nuevo</a>
<?php endif; ?>
<?php if(array_key_exists('type', $columns[0]) and $columns[0]['type'] == 'check'): ?>
	<form method="POST" style="display:inline;" id="massive_form" action="<?php echo e(route($route.'.delete_massive')); ?>">
		<?php echo method_field('POST'); ?>
		<?php echo csrf_field(); ?>
		<input type="hidden" id="selected_rows" name="selected_rows" />
		<button type="button" id="delete_massive" class="btn btn-danger"><i class="fas fa-times"></i> Eliminar Masivo</button>
	</form>
<?php endif; ?>
<br />
<br />
<div class="table-responsive">
	<table class="table table-striped table-bordered data-table">
		<thead>
			<?php $__currentLoopData = $columns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $col): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
				<th>
					<?php if(array_key_exists('type', $col) and $col['type'] == 'check'): ?>
						<input type="checkbox" id="select_all" />
					<?php else: ?>
						<?php echo e($col['title']); ?>

					<?php endif; ?>
				</th>
			<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
			<th>Actions</th>
		</thead>
		<tbody>
			<?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
				<tr>
					<?php $__currentLoopData = $columns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $col): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					<?php
						$key = $col['key'];
						$type = "text";
						if(array_key_exists("type", $col)){
							$type = $col['type'];
						}
					?>
	                  <td>
	                  	<?php switch($type):
	                  		case ('text'): ?>
	                  			<?php if($d->$key): ?>
	                  				<?php echo e($d->$key); ?>

	                  			<?php else: ?>
	                  				-
	                  			<?php endif; ?>
	                  		<?php break; ?>

	                  		<?php case ('currency'): ?>
	                  			<?php echo e($col['data']['symbol']); ?> <?php echo e(number_format($d->$key,2,',','.')); ?>

	                  		<?php break; ?>

	                  		<?php case ('img'): ?>
	                  			<?php if(!empty($d->$key)): ?>
	                  				<img src="<?php echo e(asset(str_replace('public','storage',$d->$key))); ?>" class="img-thumbnail" style="width:100px; height: 100px;" alt="image">
	                  			<?php else: ?>
	                  				Sin Imagen
	                  			<?php endif; ?>
	                  		<?php break; ?>

	                  		<?php case ('replace_text'): ?>
	                  			<?php echo e($col['data'][$d->$key]); ?>

	                  		<?php break; ?>

	                  		<?php case ('relation'): ?>
	                  			<?php
	                  				$format = "plain";
	                  				$relation = $col['data']['relation'];
	                  				$key = $col['data']['key'];
	                  				if(array_key_exists("format",$col['data'])){
	                  					$format = $col['data']['format'];
	                  				}
	                  			?>

	                  			<?php if(@$format == 'plain'): ?>
	                  				<?php if(!empty($d->$relation)): ?>
	                  					<?php echo e(@$d->$relation->$key); ?>

	                  				<?php else: ?>
	                  					<?php if(array_key_exists("default_text", $col['data'])): ?>
	                  						<?php echo e($col['data']['default_text']); ?>

	                  					<?php endif; ?>
	                  				<?php endif; ?>
	                  			<?php else: ?>
	                  				<?php if(!empty($d->$relation)): ?>
	                  					<?php echo @$d->$relation->$key; ?>

	                  				<?php else: ?>
	                  					<?php if(array_key_exists("default_text", $col['data'])): ?>
	                  						<?php echo e($col['data']['default_text']); ?>

	                  					<?php endif; ?>
	                  				<?php endif; ?>
	                  			<?php endif; ?>
	                  			
	                  		<?php break; ?>

	                  		<?php case ('date'): ?>
	                  			<?php if(!empty($d->$key)): ?>
	                  				<?php echo e(date($col['data']['format'], strtotime($d->$key))); ?>

	                  			<?php else: ?>
	                  				-
	                  			<?php endif; ?>
	                  		<?php break; ?>

	                  		<?php case ('html'): ?>
	                  			<?php echo $d->$key; ?>

	                  		<?php break; ?>
	                  		<?php case ('check'): ?>
	                  			<input type="checkbox" name="multi_select[]" value="<?php echo $d->$key; ?>">
	                  		<?php break; ?>
	                  	<?php endswitch; ?>
	                  </td>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					<td>
						<?php if($route == 'movements' && Auth::user()->role == 'reseller'): ?>
							<?php if($settings->allow_reseller_ae_movements == 1): ?>
								<?php echo $__env->make('admin.partials.actions',[ 'route'=>$route, 'id' => $d->id ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
							<?php endif; ?>
						<?php else: ?>
							<?php echo $__env->make('admin.partials.actions',[ 'route'=>$route, 'id' => $d->id ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
						<?php endif; ?> 
					</td>
				</tr>
			<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
		</tbody>
	</table>
</div><?php /**PATH /home/teleflix/public_html/panel.teleflixstream.com/resources/views/admin/partials/table.blade.php ENDPATH**/ ?>