<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Provider;
use Session;
use Auth;

class ProviderController extends Controller
{
    public function index()
    {
        $title = "Proveedor";

        $columns = [
            [
                'title'=>'#',
                'key'=>'id'
            ],
            [
                'title'=>'Nombre',
                'key'=>'name'
            ]
        ];

        $data = Provider::all();

        return view('admin.providers.browse', compact('title','columns', 'data'));
    }
    public function create()
    {
        $title = "Nuevo Proveedor";
        $type = "new";
        return view('admin.providers.add-edit', compact('title','type'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'name'=>'required'
        ]);

        $element = new Provider();
        $element->name = $request->name;
        if($element->save()){
            Session::flash('success', 'Registro Insertado con Exito!!');
        }else{
            Session::flash('error', 'Ocurrio un error al tratar de insertar el Registro!!');
        }

        return redirect()->route('providers.index');
    }

    public function show(string $id)
    {

    }

    public function edit(string $id)
    {
        $title = "Editar Proveedor";
        $type = "edit";
        $data = Provider::findorfail($id);
        return view('admin.providers.add-edit', compact('title','type','data'));
    }

    public function update(Request $request, string $id)
    {
        $request->validate([
            'name'=>'required'
        ]);

        $element = Provider::findorfail($id);
        $element->name = $request->name;
        if($element->update()){
            Session::flash('success', 'Registro Actualizado con Exito!!');
        }else{
            Session::flash('error', 'Ocurrio un error al tratara de Actualizar el Registro!!');
        }

        return redirect()->route('providers.index');
    }

    public function destroy(string $id)
    {
        $element = Provider::findorfail($id);
        if(isset($element->cover) and !empty($element->cover)){
            Storage::delete($element->cover);
        }
        if($element->delete()){
            Session::flash('success', 'Registro Eliminado con Exito!!');
        }else{
            Session::flash('error', 'Ocurrio un error al tratar de Eliminar el Registro!!');
        }

        return redirect()->route('providers.index');
    }
}
